cd "$master"
clear


use input\safecare_raw, clear
global management_keep "newcriterionscore1_1_1_1 newcriterionscore1_1_2_1 newcriterionscore1_1_3_1 newcriterionscore1_2_1_1 newcriterionscore1_2_2_1 newcriterionscore1_2_3_1 newcriterionscore1_2_4_1 newcriterionscore1_2_5_1 newcriterionscore1_2_6_1 newcriterionscore1_2_7_1 newcriterionscore1_2_8_1 newcriterionscore11_1_1_1 newcriterionscore11_2_2_1 newcriterionscore11_3_1_1 newcriterionscore11_3_2_1 newcriterionscore11_4_1_1 newcriterionscore11_4_3_1 newcriterionscore11_5_1_1 newcriterionscore12_2_1_1 newcriterionscore13_3_1_1 newcriterionscore13_3_2_1 newcriterionscore13_3_3_1 newcriterionscore2_1_1_1 newcriterionscore2_1_2_1 newcriterionscore2_2_1_1 newcriterionscore2_2_2_1 newcriterionscore2_2_3_1 newcriterionscore2_3_1_1 newcriterionscore2_3_2_1 newcriterionscore3_1_5_1 newcriterionscore3_1_6_1 newcriterionscore3_2_1_1 newcriterionscore4_1_1_1 newcriterionscore4_1_2_1 newcriterionscore4_2_1_1 newcriterionscore5_3_1_1 newcriterionscore5_3_2_1 newcriterionscore6_2_1_1 newcriterionscore6_3_2_1 newcriterionscore6_3_4_1 newcriterionscore6_4_1_1 newcriterionscore6_5_5_1 newcriterionscore7_1_1_1 newcriterionscore7_1_2_1 newcriterionscore7_2_3_1 newcriterionscore7_3_2_1 newcriterionscore8_5_5_1 newcriterionscore9_1_1_1 newcriterionscore9_2_1_1 newcriterionscore9_3_2_1 newcriterionscore9_3_3_1 newcriterionscore9_3_5_1 newcriterionscore9_3_6_1 newcriterionscore9_3_7_1 newcriterionscore9_3_8_1"
drop serviceelementscore10 -criterionscore9_3_9_4 
sum $management_keep
egen management_score_count=rownonmiss($management_keep)
egen management_score_mean=rowmean($management_keep)

global patient "newcriterionscore11_5_1_1 newcriterionscore13_3_1_1 newcriterionscore13_3_2_1 newcriterionscore13_3_3_1 newcriterionscore5_3_1_1 newcriterionscore5_3_2_1 newcriterionscore6_3_2_1 newcriterionscore6_3_4_1 newcriterionscore7_1_2_1 newcriterionscore7_3_2_1 newcriterionscore8_5_5_1"
global drug "newcriterionscore1_2_3_1 newcriterionscore11_1_1_1 newcriterionscore11_2_2_1 newcriterionscore11_3_1_1 newcriterionscore11_3_2_1 newcriterionscore11_4_1_1 newcriterionscore11_4_3_1 newcriterionscore12_2_1_1 newcriterionscore7_2_3_1 newcriterionscore9_3_5_1"
global financial "newcriterionscore1_2_5_1 newcriterionscore1_2_6_1 newcriterionscore1_2_7_1"
global hr "newcriterionscore2_1_1_1 newcriterionscore2_1_2_1 newcriterionscore2_2_1_1 newcriterionscore2_2_2_1 newcriterionscore2_2_3_1 newcriterionscore2_3_1_1 newcriterionscore2_3_2_1"
global leader "newcriterionscore1_1_2_1 newcriterionscore1_1_3_1 newcriterionscore1_2_1_1 newcriterionscore1_2_2_1 newcriterionscore1_2_4_1"
global monitoring "newcriterionscore4_1_1_1 newcriterionscore4_1_2_1"
global operations "newcriterionscore1_2_8_1 newcriterionscore3_1_5_1 newcriterionscore3_1_6_1 newcriterionscore3_2_1_1 newcriterionscore4_2_1_1 newcriterionscore6_2_1_1 newcriterionscore6_4_1_1 newcriterionscore6_5_5_1 newcriterionscore7_1_1_1 newcriterionscore9_1_1_1 newcriterionscore9_2_1_1 newcriterionscore9_3_2_1 newcriterionscore9_3_3_1 newcriterionscore9_3_6_1 newcriterionscore9_3_7_1 newcriterionscore9_3_8_1"
egen patient_score=rowmean($patient)
egen drug_score=rowmean($drug)
egen financial_score=rowmean($financial)
egen hr_score=rowmean($hr)
egen leader_score=rowmean($leader)
egen monitoring_score=rowmean($monitoring)
egen operations_score=rowmean($operations)
alpha $management_keep, std item

egen n = count(mean_basic_score), by (code)
g endline=(visitid==2) if visitid!=.

factor $management_keep if endline==1, pcf
predict management_score_mean_pcf

foreach var of varlist $management_keep {
sum `var' if endline==1
scalar mean=r(mean)
scalar sd=r(sd)
g z_`var'=(`var'-mean)/sd
}
sum z*
egen z_management_score_mean=rowmean(z_newcriterionscore1_1_1_1- z_newcriterionscore9_3_8_1) if endline==1
foreach var of varlist z_management_score_mean {
sum `var'
scalar average=r(mean)
scalar sd=r(sd)
replace `var'=(`var'-average)/sd
}
drop newcriterionscore10_1_1_1- newcriterionscore9_3_9_4 z_newcriterionscore1_1_1_1- z_newcriterionscore9_3_8_1

sum mean_basic_score if endline==1 & treat_binary==0
scalar average=r(mean)
scalar sd=r(sd)
g z_mean_basic_score=(mean_basic_score-average)/sd
sum z_mean_basic_score if endline==1 & treat_binary==0
sum z_mean_basic_score if endline==1 & treat_binary==1

xtset code endline
g D_management_score_mean=D1.management_score_mean
g D_mean_basic_score_mean=D1.mean_basic_score
g baseline_mean_basic_score=L1.mean_basic_score
g baseline_management_score_mean=L1.management_score_mean

duplicates tag code, gen(tag)
drop if endline==0 & tag==1
replace baseline_mean_basic_score=mean_basic_score if tag==0
replace baseline_management_score_mean=management_score_mean if tag==0
replace mean_basic_score=. if tag==0
replace management_score_mean=. if tag==0

keep code management_score_mean management_score_mean_pcf z_management_score_mean patient_score drug_score financial_score hr_score leader_score monitoring_score operations_score baseline_management_score_mean

save output\clean_safecare, replace